#' List of botanical attributes of plant species 
#'
#' @usage
#' data(spplist)
#'
#' @format
#' The list contains the following fields:
#' \describe{
#'   \item{numtaxon}{Unique number of the taxon (i.e., species).}
#'   \item{kingdom}{Taxonomic rank Kingdom. In this datase, all species belong to the Kingdom Plantae.}
#'   \item{division}{Taxonomic rank division or phylum within the Kingdom.}
#'   \item{class}{Taxonomic rank Class within the Kingdom.}
#'   \item{orden}{Taxonomic rank Order within the Class.}
#'   \item{family}{Taxonomic rank Family within the Order.}
#'   \item{spp.ci.full}{Full scientific name including author.}
#'   \item{spp.ci.gen}{Solely the genus of the scientific name.}
#'   \item{spp.ci.epi}{Solely the epithet of the scientific name.}
#'   \item{authorspp}{Species botanical-author.}
#'   \item{subspp}{Subspecies: one of two or more populations of a species varying from one another by morphological characteristics.}
#'   \item{authorsubspp}{Sub-species botanical-author.}
#'   \item{variety}{}
#'   \item{authorvar}{}
#'   \item{shape}{Shape}
#'   \item{authorshape}{Shape's author.}
#'   \item{comnames}{Species common name(s). With blank spaces,  no special characters.}
#'   \item{synonymy}{Synonyms of the scientific name by which the species has been or is known.}
#'   \item{borcount}{Border countries given the species distribution range.}
#'   \item{habit}{The general appearance, growth form, or architecture e.g., tree, shrub, grass.}
#'   \item{lifecycle}{Life cycle.}
#'   \item{statusori}{Status according to the species origin: Native or Endemic}
#'   \item{regdist}{Distribution range of the species, within Chile administrative regions}
#' \item{elerange}{Elevation range of the species, in meters above sea level.}
#'   \item{note}{}
#'   \item{sppcode}{Abreviattion of the species according to the Forest
#' Biometrics and Modelling Lab at the Universidad de Chile (\url{https://biometriaforestal.uchile.cl}). For
#' instance,  `ap` stands for the species _Aextoxicon punctatum_, `lh`
#' for _Lomatia hirsuta_, and alike. Meanwhile `nob` is _Nothofagus obliqua_
#'  and `nal` to _Nothofagus alpina_.} 
#'   \item{spp.name}{Species common name. No blank spaces,  no special characters.}
#'   \item{spp.ci.abb}{Species scientific name abbreviation.}
#'   \item{spp.ci.name}{Species scientific name.}
#'   \item{spp.co.name.latex}{Species common name in LaTeX}
#'   \item{spp.co.name}{Species single common name.}
#' }
######################################################################
'spplist'
