% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignspp.r
\name{assignspp}
\alias{assignspp}
\title{Assign species botanical information to a data frame}
\usage{
assignspp(
  data,
  attri = c("spp.name", "spp.ci.name"),
  refcol = "sppcode",
  all.x = TRUE,
  attri.all = FALSE,
  ...
)
}
\arguments{
\item{data}{A dataframe where to assign the species information.}

\item{attri}{A string vector having the attributes of the species
to be assigned from the species list contained in \link{spplist}.
This vector, by default, has two attributes: \code{spp.name} and
\code{spp.ci.name}, representing the common name and the scientific
name, respectively. Other alternatives are, among others,
\code{spp.ci.abb} (abbreviated scientific name), \code{genus} (genus of the
species), and \code{family} (family of the species).}

\item{refcol}{A string having the common column name to be used for
linking both the dataset and the species list. In
\link{spplist}, all the attributes available for the species
list are detailed, showing all the information that can be joined
to the dataset. Notice that the \code{refcol} has to exist in both the
dataset and the species list. Additional options of the
\code{\link[base:merge]{base::merge()}} function can be passed to the current \code{assignspp()}
function.}

\item{all.x}{Whether to preserve not finded values (\code{TRUE},
default) or not (\code{FALSE}).}

\item{attri.all}{By default is set to \code{FALSE}, otherwise, will
overwrite the vector provided in option \code{attri}, with all the
attributes available in the species list.}

\item{...}{Other options for controlling the \code{\link[base:merge]{base::merge()}}
function, which is internally loaded.}
}
\value{
A dataframe object including the attributes defined in
the parameter \code{attri}.
}
\description{
Assigns species botanical attributes to a dataset,
based upon a reference column (\code{refcol}). The attributes can be
any of the fields available in the \link{spplist} dataframe,
such as: \code{spp.ci.name} (genus and epitetus name of the species),
\code{spp.name} (common name), and \code{spp.ci.abb}
(abbreviated scientific name).
}
\examples{
## example data frame
myData <- data.frame(narb = c(1, 2, 3),
                     sppcode = c("nob", "np", "nd"),
                     dbh = c(20, 14, 23))
myData


## assign common, scientific and abbreviated name, based on `esp` value (default)
assignspp(myData)

## Assign more than one attribute based on common name
## just to remember, adding a single attribute (different from the default)
assignspp(myData, attri = "spp.ci.name")
## now, a more real example
newData <- assignspp(myData, attri = c("spp.name","genus","spp.ci.abb"))
newData 
## by default this function preserve names not found in biometrics::spplist
missingData <- rbind(myData, c(4, "notFoundData", 30))
missingData
assignspp(missingData, attri = "spp.name")
##the latter can be modified with option `all.x` of the `merge()` function
assignspp(missingData, attri = "spp.name", all.x = FALSE)
## In the case of wanting all the attributes to be merged, set option
## `attri.all` to `TRUE`, which willl overwrite the vector `attri`.
assignspp(missingData, attri = "spp.name", attri.all=TRUE, all.x =
FALSE)

}
\seealso{
\link{spplist} and \code{\link[base:merge]{base::merge()}}.
}
