% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymregfx.r
\name{asymreg.fx}
\alias{asymreg.fx}
\title{Function to compute the result of the asymptotic
regression model, as an allometric functional form.}
\usage{
asymreg.fx(x, a = alpha, b = beta, phi = 0)
}
\arguments{
\item{x}{is the predictor variable.}

\item{a}{is the coefficient-parameter  \eqn{\alpha}.}

\item{b}{is the  coefficient-parameter  \eqn{\beta}.}

\item{phi}{is an optional constant term that force the prediction
of \emph{y} when \emph{x=0}. Thus, the new model becomes
\eqn{ y_i = \alpha + \left(\phi-\alpha\right) \left\{\mathrm{e}^{
\left[-\left(\mathrm{e}^{-\beta}\right) x_i \right]
}\right\} }, thus the model will have only two parameters.
By default \eqn{\phi} is set to \code{0}.}
}
\value{
Returns the response variable based upon
the predictor variable and the coefficients.
}
\description{
Function of the asymptotic regression model, based
upon its parameters and a variable, as
follows
\deqn{y_i= \alpha +
\left(\beta-\alpha\right) \left\{\mathrm{e}^{
\left[-\left(\mathrm{e}^{-\gamma}\right) x_i \right]
}\right\},
}
where: \eqn{y_i} and \eqn{x_i} are the response
and predictor variable, respectively, for the \emph{i}-th observation;
and the rest are parameters (i.e., coefficients).
}
\examples{
#---------------------
# 2-parameters variant
# Predictor variable values to be used
time<-seq(0,50,by=0.1)
# Using the function, phi must be provided
y<-asymreg.fx(x=time,a=20,b=2.5,phi =5)
plot(time,y,type="l",ylim=c(0,20))
 
}
\references{
\itemize{
\item Pinheiro JC, DM Bates. 2000. Mixed-effects Models in S and
Splus. New York, USA. Springer-Verlag. 528 p.
\item Salas-Eljatib C. 2025. Funciones alométricas: reparametrizaciones
y características matemáticas. Documento de trabajo No. 1,
Serie: Cuadernos de biometría, Laboratorio de Biometría y
Modelación Forestal, Universidad de Chile. Santiago, Chile. 51 p.
\url{https://biometriaforestal.uchile.cl}
}
}
\author{
Christian Salas-Eljatib.
}
