% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bankfit.r
\name{bankfit}
\alias{bankfit}
\title{Function that fits a list of models on a given dataframe.}
\usage{
bankfit(modlist, data, file = NULL, file.full = FALSE, trace = FALSE, ...)
}
\arguments{
\item{modlist}{List that contains the models to be fitted.
To know the structure, see examples below.}

\item{data}{\code{dataframe} that contains the values that correspond to
observed values and variables as columns.}

\item{file}{a (writable binary-mode) connection or the name of the
file where the data will be saved (when tilde expansion is done).}

\item{file.full}{wheter to include all output (\code{TRUE}) or
just the fitted models plus their respective \code{pred.f} field
(\code{FALSE}, default).}

\item{trace}{logical value indicating if a trace of the iteration
progress of \code{\link[stats:nls]{stats::nls()}} should be printed (\code{TRUE}) or not
(\code{FALSE}, default).}

\item{...}{Other options used to control de behavior of
\code{\link[stats:nls]{stats::nls()}}.}
}
\description{
Function that fits a list of models on a given dataframe.
}
\examples{
model.list <- list(
    mod1 = list(expr = vtot ~ I(dap^2) + I(dap^2 * atot^2) +I(d6),
                pred.f = function(x, ...) x,
                type = "lm"),
    mod2 = list(expr = I(log(vtot)) ~ I(log(dap)) + I(log(atot)),
                pred.f = function(x, ...) exp(x),
                type = "lm"))

## example dataframe
df <- treevolruca2
head(df)

## fitting models to dataframe
bankfit(modlist = model.list, data = df)

}
