% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bankpred.r
\name{bankpred}
\alias{bankpred}
\title{Predicts the variable of interest for each model of the list}
\usage{
bankpred(
  file = stop("You must provide a bankfit output object"),
  data = stop("You must provide a dataframe")
)
}
\arguments{
\item{file}{The output from \code{\link[=bankfit]{bankfit()}} as a file path
or object.}

\item{data}{A dataframe for the prediction of the response
variable's values using the models fitted in \code{file}.}
}
\description{
The function predicts the variable of biometrics-interest for each
model belonging to the list previously fitted, as well as,
generates a dataframe with the results.
}
\examples{
\dontrun{
## list of example models
model.list <- list(
    mod1 = list(expr = vtot ~ I(dap^2) + I(dap^2 * atot^2) +I(d6),
                pred.f = function(x, ...) x,
                summodel = function(x, ...) datana::modresults(x)),
    mod2 = list(expr = I(log(vtot)) ~ I(log(dap)) + I(log(atot)),
                pred.f = function(x, ...) exp(x),
                summodel = function(x, ...) datana::modresults(x)))

## example dataframe
df <- treevolruca2
head(df)

## fitting models to dataframe and saving them
bankfit(models = model.list, data = df, file = "out.rdata")


## using fitted models file from biometrics::bankfit()
bankpred(file = "out.rdata", data = df) 
}
}
