% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubica.r
\name{cubica}
\alias{cubica}
\title{Compute taper volume}
\usage{
cubica(
  dl,
  hl,
  hstump = NA,
  htop = NA,
  dlu = NA,
  hlu = NA,
  full.tree = TRUE,
  pred = FALSE,
  rel.vol = c(25, 30, 40, 50, 90),
  ...
)
}
\arguments{
\item{dl}{\code{vector} of diameters. Has to have the same length as \code{hl}}

\item{hl}{\code{vector} of heights. Has to have the same length as \code{dl}}

\item{hstump}{a numeric value indicating the stump height. If
missing and \code{pred == FALSE} it defaults to the height of the first
section.}

\item{htop}{a numeric value indicating the height to crown base. If
missing and \code{pred == FALSE} it defaults to the height of the next
to last section.}

\item{dlu}{numeric values indicating comercial diameters. If the
values doesn't exists in the data they are interpolated via
datana::interp.}

\item{hlu}{numeric values indicating comercial heights. If the
values doesn't exists in the data they are interpolated via
datana::interp.}

\item{full.tree}{wheter the data comes from a full tree having
stump, stemp and crown (\code{TRUE}, default) or just stem data
(\code{FALSE}).}

\item{pred}{wheter the data comes from measured data (\code{FALSE},
default) or from predicted values (\code{TRUE}).}

\item{rel.vol}{numerical values of relative volumes, used to
compute the corresponding height and diameter.}

\item{...}{optional parameters to pass to \code{\link[datana:interp]{datana::interp()}}.}
}
\value{
A list with data.frames with the different volumes
calculated.
}
\description{
Performs the cubication of taper data. If the data
corresponds to a full tree, and \code{pred == FALSE} the calculation is
performed as a cilinder for the stump, smalian for each section in
the stem and a cone for the crown. Otherwise, just smalian is used
and a sum is performed up to the corresponding heights.
}
\examples{
\dontrun{
## generating suitable data
df <- data.frame(dl = c(31.1, 25.8, 21.2, 19.6, 17.9, 15.9, 13.5,  9.8,  7.3, 0),
                 hl = c(0.30, 0.80, 1.30, 4.88, 9.76, 12.20, 14.64, 19.52, 24.40, 31.1),
                 hstump = c(0.30, 0.30, 0.30, 0.30, 0.30, 0.30, 0.30, 0.30, 0.30, 0.30),
                 htop = c(24.40, 24.40, 24.40, 24.40, 24.40, 24.40, 24.40, 24.40, 24.40, 24.40))
df

cubica(dl = df$dl,
       hl = df$hl,
       hstump = unique(df$hstump),
       htop = unique(df$htop))

## adding commercial volumes
cubica(dl = df$dl,
       hl = df$hl,
       dlu = c(20, 15, 21.2),
       hstump = unique(df$hstump),
       htop = unique(df$htop))
}
}
\author{
Christian Salas-Eljatib and Nicolás Campos
}
