% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curtis.r
\name{curtis.fx}
\alias{curtis.fx}
\title{Function to computes the result of the Curtis's allometric
model.}
\usage{
curtis.fx(x, a = alpha, b = beta, phi = 0)
}
\arguments{
\item{x}{is the predictor variable.}

\item{a}{is the coefficient-parameter  \eqn{\alpha}.}

\item{b}{is the  coefficient-parameter  \eqn{\beta}.}

\item{phi}{is an optional constant term that force the prediction
of \emph{y} when \emph{x=0}. Thus, the new model becomes
\eqn{ y_i = \phi+ f(x_i,\mathbf{\theta})}, where
\eqn{\mathbf{\theta}} is the vector of coefficients of
the above described function represented by
\eqn{f(\cdot)}. The default
value for \eqn{\phi} is 0.}
}
\value{
Returns the response variable based upon
the predictor variable and the coefficients.
}
\description{
Function of the traditional Curtis' allometric model, based
upon two parameters, and a single predictor variable as
follows
\deqn{y_i= \alpha \left(\frac{x_i}{1+x_i} \right)^{\beta},}
where: \eqn{y_i} and \eqn{x_i} are the response
and predictor variable, respectively for the \emph{i}-th observation;
and the rest are parameters (i.e., coefficients).
}
\examples{
# Predictor variable values to be used
time<-seq(5,60,by=0.01)
# Using the function
y<-curtis.fx(x=time,a=20,b=8)
plot(time,y,type="l")
 
}
\references{
\itemize{
\item Curtis RO. 1967. Height-diameter and height-diameter-age
equations for second-growth Douglas-fir. Forest Sci. 13(4):365-375.
\item Salas-Eljatib C. 2025. Funciones alométricas: reparametrizaciones
y características matemáticas. Documento de trabajo No. 1,
Serie: Cuadernos de biometría, Laboratorio de Biometría y
Modelación Forestal, Universidad de Chile. Santiago, Chile. 51 p.
\url{https://biometriaforestal.uchile.cl}
}
}
\author{
Christian Salas-Eljatib.
}
