% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dg.fx.r
\name{dg.fx}
\alias{dg.fx}
\title{Function to computes the diameter of the tree of average basal area.}
\usage{
dg.fx(n = n, g = g, metrics = TRUE)
}
\arguments{
\item{n}{is stand tree density. By default the unit of measurement
is trees/ha, but if the option 'metrics' is set to \code{FALSE}, the unit is
trees/acre.}

\item{g}{is stand basal area. By default the unit of measurement
must be entered in m\eqn{^{2}}{^2}/ha, but if the option 'metrics'
is set to \code{FALSE}, the unit must be ft\eqn{^{2}}{^2}/ha.}

\item{metrics}{is a logic value, the default is set to \code{TRUE},
thus both variables must be entered in the metric system, i.e.,
\eqn{N} in 'trees/ha', and \eqn{G} in m\eqn{^{2}}{^2}/ha.
If metrics is \code{FALSE}, \eqn{N} must be in
trees/acre, and \eqn{G} in ft\eqn{^{2}}{^2}/acre.}
}
\value{
Returns the diameter of the tree of average basal area.
}
\description{
Function to compute the diameter of the tree of average basal
area (\eqn{D_{\overline{g}}}),
which depends on stand density (\eqn{N}) and stand basal area (\eqn{G}).
The aforementioned stand diameter is computed as
\deqn{D_{\overline{g}} = \sqrt{ \frac{G}{N} \frac{k}{pi}}}
where the constant \eqn{k} depends on whether the variables are in the
units of measurement of the metric or imperial system.
}
\examples{

##Using the function
dg.fx(n=1000, g=55)
dg.fx(n=210, g=160, metrics=FALSE)
}
\author{
Christian Salas-Eljatib.
}
