% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-eucaplotr.r
\docType{data}
\name{eucaplotr}
\alias{eucaplotr}
\title{Tree-list (realistic-) data in a sample plot established in a
\emph{Eucalyptus globulus} plantation in southern Chile.}
\format{
The dataframe contains four variables as follows:
\describe{
\item{dbh}{Diameter at breast height, in cm.}
\item{health}{health status (1: good, 2: medium, 3: bad).}
\item{shape}{stem shape for timber purposes (1: good, 2:
medium, 3: bad).}
\item{crown.class}{Crown class (1: superior, 2: intermedium,
3: lower).}
\item{toth}{Total height (in m), only available for some trees.
Otherwise missing values are denoted by \code{NA}.}
}
}
\source{
The data were provided courtesy of Dr
Christian Salas-Eljatib (Universidad de Chile, Santiago, Chile).
}
\usage{
data(eucaplotr)
}
\description{
Tree-level variables collected in a sample plot (area=500 m\eqn{^{2}}{^2})
in a forestry plantation of \emph{Eucalyptus globulus} near Gorbea, in southern
Chile. The variable height, was only measured in a sub-sample of
trees within the plot. The plantation is 15 yr-old and had been subject to
three thinnings.
}
\examples{
data(eucaplotr)    
table(eucaplotr$shape)
library(datana) 
descstat(eucaplotr[,c("dbh","toth")])
}
\references{
\itemize{
\item Forest biometrics lecture notes, Prof. Christian Salas-Eljatib,
Universidad de Chile. Santiago, Chile
}
}
\keyword{datasets}
