% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hossfeld.r
\name{hossfeld.fx}
\alias{hossfeld.fx}
\title{Function that computes the result of the Hossfeld allometric
model.}
\usage{
hossfeld.fx(x, a = alpha, b = beta, c = gamma, phi = 0)
}
\arguments{
\item{x}{is the predictor variable.}

\item{a}{is the coefficient-parameter  \eqn{\alpha}.}

\item{b}{is the  coefficient-parameter  \eqn{\beta}.}

\item{c}{is the  coefficient-parameter  \eqn{\gamma}.}

\item{phi}{is an optional constant term that force the prediction
of \emph{y} when \emph{x=0}. Thus, the new model becomes
\eqn{ y_i = \phi+ f(x_i,\mathbf{\theta})}, where
\eqn{\mathbf{\theta}} is the vector of coefficients of
the above described function represented by
\eqn{f(\cdot)}. The default
value for \eqn{\phi} is 0.}
}
\value{
Returns the response variable based upon
the predictor variable and the coefficients.
}
\description{
Function of the Hossfeld (actually it is "Hoßfeld") allometric
model, based upon parameters (i.e., coefficients) and a variable,
as defined by the mathematical expression
\deqn{y_i= \alpha
\left(\frac{1}{1+\frac{\beta}{x_i^{\gamma}}}\right),
}
where: \eqn{y_i} and \eqn{x_i} are the response
and predictor variable, respectively, for the \emph{i}-th observation;
and the rest are parameters (i.e., coefficients).
Further details on this function can be found in
Salas-Eljatib (2025).
}
\examples{
# Predictor variable values to be used
time<-seq(5,60,by=0.01)
# Using the function
y<-hossfeld.fx(x=time,a=31,b=38,c=1.4)
plot(time,y,type="l")
 
}
\references{
\itemize{
\item Hoßfeld JW. 1822. Mathematik für Forstmänner, Oekonomen und
Cameralisten. Dresden, Germany. Gotha:Hennings. 472 p.
\item Salas-Eljatib C. 2025. Funciones alométricas: reparametrizaciones
y características matemáticas. Documento de trabajo No. 1,
Serie: Cuadernos de biometría, Laboratorio de Biometría y
Modelación Forestal, Universidad de Chile. Santiago, Chile. 51 p.
\url{https://biometriaforestal.uchile.cl}
}
}
\author{
Christian Salas-Eljatib.
}
