% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmweibull.r
\name{mmweibull}
\alias{mmweibull}
\title{Function to estimates the parameters of the Weibull
probability density function using the method of moments}
\usage{
mmweibull(y)
}
\arguments{
\item{y}{a vector having the randon variable values.}
}
\value{
The main output is a list with the two
estimated parameters and the number of observations being used
for estimating the parameters.
}
\description{
Estimates the parameters of the Weibull probability density
function based on the method of moments. It is based on the
2-parameter reparemetrization of the function, i.e., the
\code{shape} and \code{scale} parameters.
}
\details{
Althought the original function was written by
Dr Oscar García, and the corresponding reference is provided,
the current function has some changes to make it of a
broader use.
}
\examples{

# Random variable to be studied
library(datana)
yvar<-llancahue$dbh
summary(yvar)
hist(yvar)
# Using the  function
mmweibull(y=yvar)
}
\references{
\itemize{
\item García, O. 1981. Simplified method-of-moments estimation for
the Weibull distribution. New Zealand Journal of
Forestry Science 11(3): 304-306.
}
}
\author{
Dr Oscar García and Christian Salas-Eljatib.
}
