% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.r
\name{power.fx}
\alias{power.fx}
\title{Function to computes the result of the power model, as a
classical allometric functional form.}
\usage{
power.fx(x, a = alpha, b = beta, phi = 0)
}
\arguments{
\item{x}{is the predictor variable.}

\item{a}{is the coefficient-parameter  \eqn{\alpha}.}

\item{b}{is the  coefficient-parameter  \eqn{\beta}.}

\item{phi}{is an optional constant term that force the prediction
of \emph{y} when \emph{x=0}. Thus, the new model becomes
\eqn{ y_i = \phi+ f(x_i,\mathbf{\theta})}, where
\eqn{\mathbf{\theta}} is the vector of coefficients of
the above described function represented by
\eqn{f(\cdot)}. The default
value for \eqn{\phi} is 0.}
}
\value{
Returns the response variable based upon
the predictor variable and the coefficients.
}
\description{
Function of the power model, based
upon the model parameters, and a single predictor variable as
follows
\deqn{ y_i = \alpha x_i^{\beta} }
where: \eqn{y_i} and \eqn{x_i} are the response
and predictor variable, respectively for the \emph{i}-th observation;
and the rest are parameters (i.e., coefficients).
}
\examples{
# Predictor variable to be used is 30 
# Using the function
power.fx(x=30,a=2.86,b=.49)
 
}
\references{
\itemize{
\item Salas-Eljatib C. 2025. Funciones alométricas: reparametrizaciones
y características matemáticas. Documento de trabajo No. 1,
Serie: Cuadernos de biometría, Laboratorio de Biometría y
Modelación Forestal, Universidad de Chile. Santiago, Chile. 51 p.
\url{https://biometriaforestal.uchile.cl}
}
}
\author{
Christian Salas-Eljatib.
}
