% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratkow.r
\name{ratkow.fx}
\alias{ratkow.fx}
\title{Function that computes the result of the Ratkowsky
allometric model.}
\usage{
ratkow.fx(x, a = alpha, b = beta, c = gamma, phi = 0)
}
\arguments{
\item{x}{is the predictor variable.}

\item{a}{is the coefficient-parameter  \eqn{\alpha}.}

\item{b}{is the  coefficient-parameter  \eqn{\beta}.}

\item{c}{is the  coefficient-parameter  \eqn{\gamma}.}

\item{phi}{is an optional constant term that force the prediction
of \emph{y} when \emph{x=0}. Thus, the new model becomes
\eqn{ y_i = \phi+ f(x_i,\mathbf{\theta})}, where
\eqn{\mathbf{\theta}} is the vector of coefficients of
the above described function represented by
\eqn{f(\cdot)}. The default
value for \eqn{\phi} is 0.}
}
\value{
Returns the response variable based upon
the predictor variable and the coefficients.
}
\description{
Function of the Ratkowsky allometric
model, based upon parameters (i.e., coefficients) and a variable,
as defined by the mathematical expression
\deqn{y_i= \alpha
\mathrm{e}^{\left(\frac{-\beta}{x_i +\gamma}\right)},
}
where: \eqn{y_i} and \eqn{x_i} are the response
and predictor variable, respectively, for the \emph{i}-th observation;
and the rest are parameters (i.e., coefficients).
Further details on this function can be found in
Salas-Eljatib (2025).
}
\examples{
# Predictor variable values to be used
d<-seq(5,60,by=0.01)
# Using the function
h<-ratkow.fx(x=d,a=28,b=34,c=.85)
plot(d,h,type="l")
 
}
\references{
\itemize{
\item Zhang L. 1997. Cross-validation of non-linear growth functions
for modelling tree height-diameter relationships. Annals of
Botany 79(3):251–257.
\item Salas-Eljatib C. 2025. Funciones alométricas: reparametrizaciones
y características matemáticas. Documento de trabajo No. 1,
Serie: Cuadernos de biometría, Laboratorio de Biometría y
Modelación Forestal, Universidad de Chile. Santiago, Chile. 51 p.
\url{https://biometriaforestal.uchile.cl}
}
}
\author{
Christian Salas-Eljatib.
}
