% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schnute.r
\name{schnute.fx}
\alias{schnute.fx}
\title{Function that computes the result of the Schnute
allometric model.}
\usage{
schnute.fx(
  x,
  a = alpha,
  b = beta,
  c = gamma,
  phi = 0,
  x1 = min(x),
  x2 = max(x)
)
}
\arguments{
\item{x}{is the predictor variable.}

\item{a}{is the coefficient-parameter  \eqn{\alpha}.}

\item{b}{is the  coefficient-parameter  \eqn{\beta}.}

\item{c}{is the  coefficient-parameter  \eqn{\gamma}.}

\item{phi}{is an optional constant term that force the prediction
of \emph{y} when \emph{x=0}. The default value for \eqn{\phi} is 0.}

\item{x1}{is the minimum value for the x variable. The default
value is internally computed from the sample.}

\item{x2}{is the maximumvalue for the x variable. The default
value is internally computed from the sample.}
}
\value{
Returns the response variable based upon
the predictor variable and the coefficients.
}
\description{
Function of the  Schnute allometric
model, based upon parameters (i.e., coefficients) and a variable,
as defined by the mathematical expression
\deqn{y_i=\left\{\phi^{\alpha}+(\gamma^{\alpha}-\phi^{\alpha})
 \frac{1-\mathrm{e}^{-\beta(x_i)}}{1-\mathrm{e}^{-\beta(x_2)}}
\right \}^{1/\alpha},}
where: \eqn{y_i} and \eqn{x_i} are the response
and predictor variable, respectively, for the \emph{i}-th observation;
and the rest are parameters (i.e., coefficients).
Further details on this function can be found in
Salas-Eljatib et al (2021).
}
\examples{
# Predictor variable values to be used
d<-seq(5,60,by=0.01)
# Using the function
h<-schnute.fx(x=d,a=1.77,b=0.01,c=28)
plot(d,h,type="l")
 
}
\references{
\itemize{
\item Schnute I. 1981. A versatile growth model with statistically
stable parameters. Can. J. Fish. Aquat. Sci. 38(9):1128-1140.
\item Salas-Eljatib C. 2025. Funciones alométricas: reparametrizaciones
y características matemáticas. Documento de trabajo No. 1,
Serie: Cuadernos de biometría, Laboratorio de Biometría y
Modelación Forestal, Universidad de Chile. Santiago, Chile. 51 p.
\url{https://biometriaforestal.uchile.cl}
}
}
\author{
Christian Salas-Eljatib.
}
