% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stage.r
\name{stage.fx}
\alias{stage.fx}
\title{Function that computes the result of the Stage  allometric
model.}
\usage{
stage.fx(x, a = alpha, b = beta, c = gamma, phi = 0)
}
\arguments{
\item{x}{is the predictor variable.}

\item{a}{is the coefficient-parameter  \eqn{\alpha}.}

\item{b}{is the  coefficient-parameter  \eqn{\beta}.}

\item{c}{is the  coefficient-parameter  \eqn{\gamma}.}

\item{phi}{is an optional constant term that force the prediction
of \emph{y} when \emph{x=0}. Thus, the new model becomes
\eqn{ y_i = \phi+ f(x_i,\mathbf{\theta})}, where
\eqn{\mathbf{\theta}} is the vector of coefficients of
the above described function represented by
\eqn{f(\cdot)}. The default
value for \eqn{\phi} is 0.}
}
\value{
Returns the response variable based upon
the predictor variable and the coefficients.
}
\description{
Function of the Stage allometric
model, based upon parameters (i.e., coefficients) and a variable,
as defined by the mathematical expression
\deqn{y_i= \alpha
\mathrm{e}^{\left(-\beta ({x_i}^{-\gamma}) \right)},
}
where: \eqn{y_i} and \eqn{x_i} are the response
and predictor variable, respectively, for the \emph{i}-th observation;
and the rest are parameters (i.e., coefficients).
Further details on this function can be found in
Salas-Eljatib (2025).
}
\examples{
# Predictor variable values to be used
time<-seq(5,60,by=0.01)
# Using the function
d<-stage.fx(x=time,a=28,b=56,c=1.19)
plot(time,d,type="l")
 
}
\references{
\itemize{
\item Stage AR. 1963. A mathematical approach to polymorphic site
index curves for Grand Fir. Forest Sci. 9(2):167-180.
\doi{10.1093/forestscience/9.2.167}
\item Salas-Eljatib C. 2025. Funciones alométricas: reparametrizaciones
y características matemáticas. Documento de trabajo No. 1,
Serie: Cuadernos de biometría, Laboratorio de Biometría y
Modelación Forestal, Universidad de Chile. Santiago, Chile. 51 p.
\url{https://biometriaforestal.uchile.cl}
}
}
\author{
Christian Salas-Eljatib.
}
