% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-standtabCoihue.r
\docType{data}
\name{standtabCoihue}
\alias{standtabCoihue}
\title{Stand table for a \emph{Nothofagus dombeyi} (coihue) forest}
\format{
The data has the following columns
\describe{
\item{diam.cl}{Diameter class, in cm.}
\item{nha}{Density for the respective diameter class,
in trees/ha.}
\item{gha}{Basal area for the respective diameter class,
in m\eqn{^{2}}{^2}/ha.}
}
}
\source{
The forest was located in the Andean foothills in the Araucanía
region in southern Chile. Data from Prof. Christian
Salas-Eljatib, Universidad de Chile, Santiago, Chile.
}
\usage{
data(standtabCoihue)
}
\description{
Stand table for a secondary forest of \emph{Nothofagus dombeyi}
(coihue) en  Chile.
}
\examples{
data(standtabCoihue)
df<-standtabCoihue
df<-df[-nrow(df),]
# Diameter distribution plot 
barplot(df$nha, legend = TRUE, beside = TRUE, las=1,
        names.arg = as.numeric(df$diam.cl),
        ylab="Density (trees/ha)",xlab="Diameter class (cm)")
abline(h=0)
}
\references{
\itemize{
\item Donoso C. 1995. Bosques Templados de Chile y Argentina.
Editorial Universitaria. Santiago, Chile.
}
}
\keyword{datasets}
