% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-standtabRauli.r
\docType{data}
\name{standtabRauli}
\alias{standtabRauli}
\title{Stand tables for \emph{Nothofagus alpina} (raulí) forests}
\format{
The data has the following columns
\describe{
\item{site}{Study site.}
\item{sector}{Location within a study site.}
\item{low.cd}{Lower limit of the diameter class, in cm.}
\item{upp.cd}{Upper limit of the diameter class, in cm.}
\item{dclass}{Diameter class, in cm.}
\item{nha.dcl}{Tree density for the respective diameter class,
in trees/ha.}
\item{forest.id}{Forest ID code, a combination of columns \code{site}
and \code{sector}.}
}
}
\source{
Tree density by diameter classes (i.e., stand table).
Data were digitized from table No. 4 of Wadsworth (1976).
}
\usage{
data(standtabRauli)
}
\description{
Stand tables for secondary \emph{Nothofagus alpina}-dominated forests
in different locations in southern Chile.
}
\examples{
data(standtabRauli)
head(standtabRauli)
df<-standtabRauli
table(df$site,df$sector,df$dclass)
}
\references{
\itemize{
\item Wadsworth RK. 1976. Aspectos ecologicos y crecimiento del
raulí (\emph{Nothofagus alpina}) y sus asociados en bosques de
segundo crecimiento
de las provincias de Bío-Bío, Malleco y Cautín, Chile.
Boletin Técnico No. 37, Fac. Cs. Forestales, Universidad de Chile,
Santiago, Chile.
}
}
\keyword{datasets}
