% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-standtabRauli2.r
\docType{data}
\name{standtabRauli2}
\alias{standtabRauli2}
\title{Tablas de rodal para bosques de \emph{Nothofagus alpina} (raulí)}
\format{
Los datos tienen las siguientes columnas
\describe{
\item{sitio}{Nombre del sitio de estudio.}
\item{sector}{Código identificador de un sector específico
dentro del sitio en estudio.}
\item{linf.cd}{Límite inferior de la clase diamétrica, en cm.}
\item{lsup.cd}{Límite superior de la clase diamétrica, en cm.}
\item{cd}{Marca de la clase diamétrica, en cm.}
\item{nha.cd}{Densidad de la clase diamétrica, en arb/ha.}
\item{bosque.id}{Identificador del bosque, combinación de
\code{sitio} y \code{sector}.}
}
}
\source{
Densidad de árboles por clase diamétrica, i.e., tabla de rodal.
Datos digitados desde el cuadro No. 4 de Wadsworth (1976).
}
\usage{
data(standtabRauli2)
}
\description{
Tablas de rodal para bosques secundarios dominados
por \emph{Nothofagus alpina} en diferentes localidades del sur de Chile.
}
\examples{
data(standtabRauli2)
head(standtabRauli2)
df<-standtabRauli2
table(df$sitio,df$sector,df$cd)
}
\references{
\itemize{
\item Wadsworth RK. 1976. Aspectos ecologicos y crecimiento del
raulí (\emph{Nothofagus alpina}) y sus asociados en bosques de
segundo crecimiento
de las provincias de Bío-Bío, Malleco y Cautín, Chile.
Boletin Técnico No. 37, Fac. Cs. Forestales, Universidad de Chile,
Santiago, Chile.
}
}
\keyword{datasets}
