% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-standtabRoble2.r
\docType{data}
\name{standtabRoble2}
\alias{standtabRoble2}
\title{Tabla de rodal media para renovales de  \emph{Nothofagus obliqua}
(roble)}
\format{
Las columnas son las siguientes
\describe{
\item{cd}{Clase diamétrica, en cm.}
\item{nha}{Densidad para la respectiva clase diamétrica,
en arb/ha.}
}
}
\source{
La tabla de rodal proviene de Puente et al. (1979), y es el
resultado de un estudio sobre los bosques secundarios de
\emph{Nothofagus} en el sur de Chile.
}
\usage{
data(standtabRoble2)
}
\description{
Tabla de rodal media para renovales dominados por
\emph{Nothofagus obliqua} (roble), que tienen entre 40 y 50 años,
en las provincias de Malleco, Cautín, y Valdiva, en el sur de
Chile.
}
\examples{
data(standtabRoble2)
df<-standtabRoble2
df<-df[-nrow(df),]
# Grafico de distribucion diametrica 
barplot(df$nha, legend = TRUE, beside = TRUE, las=1,
        names.arg = df$cd,
        ylab="Densidad (arb/ha)",xlab="Clase diametrica (cm)")
abline(h=0)
}
\references{
\itemize{
\item Puente M, C Donoso, R Peñaloza, E Morales. 1979. Estudio de
raleo y otras técnicas para el manejo de renovales de
raulí (\emph{Nothofagus alpina}) y roble (\emph{Nothofagus obliqua}).
Etapa I: Identificación y caracterización de renovales de raulí
y roble. Informe de convenio No. 5, Proyecto
CONAF/PNUD/FAO-CHI/76/003, Santiago, Chile. 88 p.
}
}
\keyword{datasets}
