% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strandg.r
\name{strandg.fx}
\alias{strandg.fx}
\title{A function having the mathematical expression of
the Strand model.}
\usage{
strandg.fx(x, a = alpha, b = beta, c = gamma, phi = 0)
}
\arguments{
\item{x}{is the predictor variable.}

\item{a}{is the coefficient-parameter  \eqn{\alpha}.}

\item{b}{is the  coefficient-parameter  \eqn{\beta}.}

\item{c}{is the  coefficient-parameter  \eqn{\gamma}.}

\item{phi}{is an optional constant term that force the prediction
of \emph{y} when \emph{x=0}. Thus, the new model becomes
\eqn{ y_i = \phi+ f(x_i,\mathbf{\theta})}, where
\eqn{\mathbf{\theta}} is the vector of coefficients of
the above described function represented by
\eqn{f(\cdot)}. The default
value for \eqn{\phi} is 0.}
}
\value{
Returns the response variable based upon
the predictor variable and the coefficients.
}
\description{
Function of the Strand generalized model, based
upon three parameters and a single predictor variable as
follows
\deqn{y_i= \left(\frac{x_i}{\alpha +\beta x_i}\right)^{\gamma},}
where: \eqn{y_i} and \eqn{x_i} are the response
and predictor variable, respectively, for the \emph{i}-th observation;
and the rest are parameters (i.e., coefficients).
}
\examples{
# Predictor variable values to be used
time<-seq(5,60,by=0.01)
# Using the function
y<-strandg.fx(x=time,a=0.98,b=0.52,c=4.83)
plot(time,y,type="l")
 
}
\references{
\itemize{
\item Strand L. 1964. Numerical constructions of site-index curves.
Forest Sci. 10(4):410-414.
\item Salas-Eljatib C. 2025. Funciones alométricas: reparametrizaciones
y características matemáticas. Documento de trabajo No. 1,
Serie: Cuadernos de biometría, Laboratorio de Biometría y
Modelación Forestal, Universidad de Chile. Santiago, Chile. 51 p.
\url{https://biometriaforestal.uchile.cl}
}
}
\author{
Christian Salas-Eljatib.
}
