% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treestat.r
\name{treestat}
\alias{treestat}
\title{Function to compute descriptive statistics at tree-level,
segregated by a factor (\code{factvar}) per sample plot.}
\usage{
treestat(
  data,
  plot.id,
  t = NA,
  y,
  d = NA,
  factvar = NA,
  full = FALSE,
  short.names = TRUE,
  metric = TRUE,
  eng = TRUE,
  want.add.d = FALSE,
  want.add.g = FALSE,
  ...
)
}
\arguments{
\item{data}{data frame having the tree list of a sample plot.}

\item{plot.id}{a string having the plot code-number or unique
identificator.}

\item{t}{(optional) a time variable having the the measurement
year (in numeric or character format). The default is \code{NA}, in
which case the current year is assigned.}

\item{y}{a string-vector with the name(s) of the random
variable(s) to which the descriptive statistics will be
computed. By default uses \code{dbh} as the name of the variable.}

\item{d}{(optional) a text with the name of the column of the
\code{data} having the diameter at breast-heigth. The default is \code{NA}.
If provided, it is assumed to be in cm. See option \code{metrics} to
change it to the imperial system.}

\item{factvar}{a string having de name of the variable
used as factor. Each level of the 'factvar` is a category.}

\item{full}{logical; if \code{TRUE}, the output includes some extra
descriptive statistics as explained in the datana::descstat()
function. The default is \code{FALSE}.}

\item{short.names}{logical; if \code{TRUE}, the name of the
statistics are short names as explained in the datana::descstat()
function. The default is \code{FALSE}.}

\item{metric}{is a logic value, the default is \code{TRUE}, thus
the diameter \code{d} has to be in cm, and the resulting tree-level
basal area will be in m\eqn{^{2}}{^2}. If \code{metric} is \code{FALSE},
the diameter \code{d} has to be in inches, and the computed tree
basal area will be in ft\eqn{^{2}}{^2}.}

\item{eng}{logical; if \code{TRUE} (by default), the language of some
of the output-column names will be English; if "FALSE" will
be Spanish. For instance, the levels of the
factor-variable (\code{factvar}) is named "level"; otherwise will be
"nivel".}

\item{want.add.d}{logical; if \code{TRUE}, the computations will
include the diameter at breast-heigth defined in option \code{d}, as an
extra random variable to be added at the end of the vector \code{y}.
The default is \code{FALSE}.}

\item{want.add.g}{logical; if \code{TRUE}, the computations will
include the tree basal area, only possible if option \code{d} was
defined, as an extra random variable to be added at the end of
the vector \code{y}. The default is \code{FALSE}.}

\item{...}{aditional options for basic stats functions.}
}
\value{
Returns a data frame with the statistics per plot and
time for the selected y variables. If \code{factvar} is given, the
same statistics will be added but segregated by each level
(or category) of the \code{factvar}.
}
\description{
Computes several descriptive statistics of variables at
the tree-level per sample plot. It can also be be applied
to compute them by levels of factor within each available plot.
}
\details{
For a given tree list of a sample plot, several
descriptive statistics are computed for the selected random
variables, by plot and measurement year.
}
\examples{

# Dataframe to be used
df<-biometrics::eucaplot2
#?eucaplot2
head(df)
datana::descstat(df[,c("dap","atot")])
df$parce<-1
## Using the function
treestat(data=df,plot.id="parce",y="atot")
# Now, for two random variables, instead of a single one 
treestat(data=df,plot.id="parce",y=c("dap","atot"))
# If the d is provided, Do you want to add both the diameter
# and the basal area (g), as random variables? 
treestat(data=df,plot.id="parce",y="atot",d="dap",want.add.d=TRUE,want.add.g=TRUE)
## Do the same as before, but adding the computation by a factor

treestat(data=df,plot.id="parce",y="atot",factvar="clase.copa")
df$time<-2025;df$time[1:5]<-2020
df
## Using the function per measurement year
treestat(data=df,plot.id="parce",y="atot",t="time",full=TRUE)
# Do the same as before, but adding the computation by a factor
treestat(data=df,plot.id="parce",y="atot",t="time",
         factvar="clase.copa",full = TRUE)
## same as before, but for two random variables
treestat(data=df,plot.id="parce",y=c("dap","atot"),t="time",
          factvar="clase.copa",full = TRUE)
}
\references{
\itemize{
\item Salas-Eljatib C. 2025. Biometría y Modelación Forestal.
Borrador de libro, en revisión. 352 p.
}
}
\author{
Christian Salas-Eljatib.
}
