% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volume.r
\name{volume}
\alias{volume}
\title{Compute volume of objects}
\usage{
volume(
  form = "trapesoid",
  d = NA,
  h = NA,
  l = NA,
  d.u = "cm",
  h.u = "m",
  l.u = "m",
  o.u = "m3"
)
}
\arguments{
\item{form}{\code{string} indicating the form of the object to be
cubicated. The alternatives are the following: \code{cone},
\code{cilinder}, \code{trapesoid} (also know as the Smalian's cubic
formula), \code{newton}, or \code{huber}.}

\item{d}{\code{vector} of diameter values.}

\item{h}{\code{vector} of height values.}

\item{l}{Distance, generally the difference between two \code{h}
values. If \code{l} is given, \code{h} must not be given.}

\item{d.u}{\code{string} indicating the unit of \code{d}. Can be any of \code{cm}
(default), \verb{in}, \code{m} or \code{ft}.}

\item{h.u}{\code{string} indicating the unit of \code{h}. Can be any of \code{cm},
\verb{in}, \code{m} (default) or \code{ft}.}

\item{l.u}{\code{string} indicating the unit of \code{l}. Can be any of \code{cm},
\verb{in}, \code{m} (default) or \code{ft}.}

\item{o.u}{\code{string} indicating the unit of the calculated
volume. Can be any of \code{cm3}, \code{in3}, \code{m3} (default) or \code{ft3}.}
}
\value{
Value of volume.
}
\description{
Calculate the volume of objects, depending on
their shapes or available measurements, to carry out the
computation.
}
\examples{
##- Data, diameters at different stem heights
df <- data.frame(hl = c(0.3, 3.9, 7), dl = c(40, 20, 10))
df

##- Cilinder, needs a single diameter and height
dst <- df$dl[1]
hst <- df$hl[1]
## output in cubic centimeters
volume(form = "cilinder", d = dst,  l = hst, o.u = "cm3")
## in meters
volume(form = "cilinder", d = dst,  l = hst, o.u = "m3")

##- Trapesoid between first and second measurement,
## thus is for a single section.
dl.a <- df$dl[c(1, 2)]
hl.a <- df$hl[c(1, 2)]

vs1<-volume(h = hl.a, d = dl.a)
vs1

##- Trapesoid, between first and third measurement
## thus is for a single section.
dl.b <- df$dl[c(1, 3)]
hl.b <- df$hl[c(1, 3)]
volume(h = hl.b, d = dl.b)


dl.b <- df$dl[c(2, 3)]
hl.b <- df$hl[c(2, 3)]
vs2<-volume(h = hl.b, d = dl.b)
vs2
vs1+vs2
##- Newton (only possible if three measurements are given)
volume(form = "newton",  h = df$hl, d = df$dl)

##- Huber, for all available measurements
volume(form = "huber", d = df$dl, h = df$hl)

##- Huber given 1 diameter and 1 distance
l.a <- diff(c(df$hl[1], df$hl[3]))
volume(form = "huber", d = df$d[2], l = l.a)

}
\author{
Christian Salas-Eljatib and Nicolás Campos and
Victor Pacheco
}
