% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wykoff.r
\name{wykoff.fx}
\alias{wykoff.fx}
\title{A function having the mathematical expression of
the Wykoff model.}
\usage{
wykoff.fx(x, a = alpha, b = beta, phi = 0)
}
\arguments{
\item{x}{is the predictor variable.}

\item{a}{is the coefficient-parameter  \eqn{\alpha}.}

\item{b}{is the  coefficient-parameter  \eqn{\beta}.}

\item{phi}{is an optional constant term that force the prediction
of \emph{y} when \emph{x=0}. Thus, the new model becomes
\eqn{ y_i = \phi+ f\left(x_i,\mathbf{\theta}\right)}, where
\eqn{\mathbf{\theta}} is the vector of coefficients of
the above described function represented by
\eqn{f(\cdot)}. The default
value for \eqn{\phi} is 0.}
}
\value{
Returns the response variable based upon
the predictor variable and the coefficients.
}
\description{
Function of the Wykoff model, based
upon two parameters and a single predictor variable as
follows
\deqn{y_i= \mathrm{e}^{\left(\alpha+\frac{\beta}{x_i+1} \right)},
}
where: \eqn{y_i} and \eqn{x_i} are the response
and predictor variable, respectively, for the \emph{i}-th
observation; and the rest are parameters (i.e., coefficients).
}
\examples{
# Predictor variable values to be used
d<-seq(5,60,by=0.01)
# Using the function
h<-wykoff.fx(x=d,a=3.87,b=4.38,phi=1.3)
plot(d,h,type="l")
 
}
\references{
\itemize{
\item Wykoff WR, NL Crookston, AR Stage. 1982. User’s guide to the
Stand Prognosis Model. USDA For. Serv. Gen. Tech. Rep.
INT-133, USA. 112 p.
\item Salas-Eljatib C. 2025. Funciones alométricas: reparametrizaciones
y características matemáticas. Documento de trabajo No. 1,
Serie: Cuadernos de biometría, Laboratorio de Biometría y
Modelación Forestal, Universidad de Chile. Santiago, Chile. 51 p.
\url{https://biometriaforestal.uchile.cl}
}
}
\author{
Christian Salas-Eljatib.
}
