% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_excel.R
\name{export_design_to_excel}
\alias{export_design_to_excel}
\title{Export Experimental Design Layout to Excel}
\usage{
export_design_to_excel(
  design_df,
  value_column = "treatments",
  filename = "experimental_design.xlsx",
  palette = "default"
)
}
\arguments{
\item{design_df}{A dataframe containing experimental design with 'row' and 'col' columns}

\item{value_column}{Character string specifying which column to use for layout values (default: "treatments")}

\item{filename}{Character string for Excel filename (default: "experimental_design.xlsx")}

\item{palette}{colour palette for treatments. Can be a palette name (see details) or vector of colours.
Set to NULL to disable colouring (default: "default")}
}
\value{
Invisibly returns the layout dataframe
}
\description{
Converts an experimental design dataframe into a spatial layout matrix
and exports to Excel with optional colour coding by treatment.
}
\details{
This function takes an experimental design in long format (with row/col coordinates)
and converts it to a matrix layout that matches the spatial arrangement of the experiment,
then exports to Excel with formatting and optional colour coding.

Valid palette options include:
\itemize{
\item "default" - Spectral palette
\item ColorBrewer palettes: "brbg", "piyg", "prgn", "puor", "rdbu", "rdgy", "rdylbu", "rdylgn", "spectral", "set3", "paired"
\item Viridis palettes: "viridis", "magma", "inferno", "cividis", "plasma", "rocket", "mako", "turbo"
\item colour blind friendly: "colour blind", "color blind", "cb" (uses viridis)
\item Custom vector of colours (must match number of unique treatments)
}

Requires the 'openxlsx' package to be installed.
}
\examples{
\dontrun{
# Export with default colours
export_design_to_excel(my_design, "treatments", "my_design.xlsx")

# Export without colours
export_design_to_excel(my_design, "treatments", "my_design.xlsx", palette = NULL)

# Export with custom palette
export_design_to_excel(my_design, "treatments", "my_design.xlsx", palette = "viridis")
}

}
