#' Image of microbeads
#'
#' This fluorescence image, formatted as 'cimg' with dimensions of
#' 1384 x 1032 pixels, shows microbeads. With a single color channel, the image
#' provides an ideal example for in-depth analysis of microbead structures.
#' The image's larger size encompasses a greater number of microbeads,
#' offering a broader range of experimental outcomes for examination.
#'
#' @format
#' The image was imported using imager and is therefore of class:
#' "cimg" "imager_array" "numeric"
#' @details
#' Dimensions: width - 1384; height - 1032; depth - 1; channel - 3
#' @references The image was provided by Coline Kieffer.
#' @examples
#' data(beads_large2)
#' plot(beads_large2)
"beads_large2"
