% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhclu_clarans.R
\name{nhclu_clarans}
\alias{nhclu_clarans}
\title{Non-hierarchical clustering: CLARANS}
\usage{
nhclu_clarans(
  dissimilarity,
  index = names(dissimilarity)[3],
  seed = NULL,
  n_clust = c(1, 2, 3),
  numlocal = 2,
  maxneighbor = 0.025,
  algorithm_in_output = TRUE
)
}
\arguments{
\item{dissimilarity}{The output object from \code{\link[=dissimilarity]{dissimilarity()}} or
\code{\link[=similarity_to_dissimilarity]{similarity_to_dissimilarity()}}, or a \code{dist} object. If a \code{data.frame} is
used, the first two columns should represent pairs of sites (or any pair of
nodes), and the subsequent column(s) should contain the dissimilarity indices.}

\item{index}{The name or number of the dissimilarity column to use. By
default, the third column name of \code{dissimilarity} is used.}

\item{seed}{A value for the random number generator (\code{NULL} for random
initialization by default).}

\item{n_clust}{An \code{integer} vector or a single \code{integer} specifying the
desired number(s) of clusters.}

\item{numlocal}{An \code{integer} defining the number of local searches to perform.}

\item{maxneighbor}{A positive \code{numeric} value defining the maximum number of
neighbors to consider for each local search.}

\item{algorithm_in_output}{A \code{boolean} indicating whether the original output
of \link[fastkmedoids:fastclarans]{fastclarans} should be included in the output.
Defaults to \code{TRUE} (see Value).}
}
\value{
A \code{list} of class \code{bioregion.clusters} with five components:
\enumerate{
\item{\strong{name}: A \code{character} string containing the name of the algorithm.}
\item{\strong{args}: A \code{list} of input arguments as provided by the user.}
\item{\strong{inputs}: A \code{list} of characteristics of the clustering process.}
\item{\strong{algorithm}: A \code{list} of all objects associated with the clustering
procedure, such as original cluster objects (only if
\code{algorithm_in_output = TRUE}).}
\item{\strong{clusters}: A \code{data.frame} containing the clustering results.}}

If \code{algorithm_in_output = TRUE}, the \code{algorithm} slot includes the output of
\link[fastkmedoids:fastclarans]{fastclarans}.
}
\description{
This function performs non-hierarchical clustering based on dissimilarity
using partitioning around medoids, implemented via the Clustering Large
Applications based on RANdomized Search (CLARANS) algorithm.
}
\details{
Based on \href{https://cran.r-project.org/package=fastkmedoids}{fastkmedoids}
package (\link[fastkmedoids:fastclarans]{fastclarans}).
}
\examples{
comat <- matrix(sample(0:1000, size = 500, replace = TRUE, prob = 1/1:1001),
20, 25)
rownames(comat) <- paste0("Site",1:20)
colnames(comat) <- paste0("Species",1:25)

dissim <- dissimilarity(comat, metric = "all")

#clust <- nhclu_clarans(dissim, index = "Simpson", n_clust = 5)
   
}
\references{
Schubert E & Rousseeuw PJ (2019) Faster k-Medoids Clustering: Improving the
PAM, CLARA, and CLARANS Algorithms. \emph{Similarity Search and Applications}
11807, 171-187.
}
\seealso{
For more details illustrated with a practical example,
see the vignette:
\url{https://biorgeo.github.io/bioregion/articles/a4_2_non_hierarchical_clustering.html}.

Associated functions:
\link{nhclu_clara} \link{nhclu_dbscan} \link{nhclu_kmeans} \link{nhclu_pam} \link{nhclu_affprop}
}
\author{
Pierre Denelle (\email{pierre.denelle@gmail.com}) \cr
Boris Leroy (\email{leroy.boris@gmail.com}) \cr
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
