% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouds.R
\name{ellipses}
\alias{ellipses}
\title{Concentration ellipses (\eqn{\kappa}-ellipses)}
\usage{
ellipses(bp, df=2, kappa = NULL, which = NULL,
alpha = 0.95, col = bp$sample$col[which], lty = 1, lwd = 1,
opacity = 0.25, trace = TRUE)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{df}{degrees of freedom, with default \code{2}.}

\item{kappa}{value to construct \eqn{\kappa}-ellipse (the value of \eqn{\kappa}).}

\item{which}{the selection of the group for ellipse construction.}

\item{alpha}{size of \eqn{\alpha}-bag, with default \code{0.95}.}

\item{col}{colour of ellipse. Multiple \eqn{\kappa}-ellipse for one group will be displayed in the same colour.}

\item{lty}{line type of ellipse. The same line type will be used per value of \eqn{\kappa}.}

\item{lwd}{line width of ellipse. The same line width will be used per value of \eqn{\kappa}.}

\item{opacity}{level of opacity, with default \code{0.25}.}

\item{trace}{logical, indicating progress of computation.}
}
\value{
A list with the following components is available:
\item{conc.ellipses}{list of coordinates for the \eqn{\kappa}-ellipses for each group.}
\item{col}{vector of colours for the \eqn{\kappa}-ellipses.}
\item{lty}{vector of line types for the \eqn{\kappa}-ellipses.}
\item{lwd}{vector of line widths for the \eqn{\kappa}-ellipses.}
\item{alpha}{vector of \eqn{\alpha} values.}
}
\description{
This function produces \eqn{\kappa}-ellipses, which is a useful geometrical description of the
data points about the sample mean.
}
\examples{
biplot (iris[,1:4]) |> PCA(group.aes=iris[,5]) |> ellipses(kappa=2) |> plot()

}
\references{
Gower, J., Gardner-Lubbe, S. & Le Roux, N. (2011, ISBN: 978-0-470-01255-0) \emph{Understanding Biplots.} Chichester, England: John Wiley & Sons Ltd.\if{html}{\out{<br>}}\if{html}{\out{<br>}}
}
