% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_groups.R
\name{sniff_groups}
\alias{sniff_groups}
\title{Detect and analyze groups in a scientific network}
\usage{
sniff_groups(
  comps,
  min_group_size = 10,
  keep_component = c("c1"),
  cluster_component = c("c1"),
  algorithm = "fast_greedy",
  seed = 888L
)
}
\arguments{
\item{comps}{A list containing network components, typically generated by
\code{\link{sniff_components}}(). Must include a network object with
'component' and 'PY' (publication year) vertex attributes.}

\item{min_group_size}{Minimum size for a group to be included in results
(default = 10). Groups with fewer members will be filtered out.}

\item{keep_component}{Character vector specifying which network components to
process (default = "c1"). Can include multiple components.}

\item{cluster_component}{Character vector specifying which components should be
clustered (default = "c1"). Components not listed here will be treated
as single groups.}

\item{algorithm}{Community detection algorithm to use (default = "fast_greedy").
Options include: "louvain", "walktrap", "edge_betweenness", "fast_greedy",
or "leiden".}

\item{seed}{Random seed for reproducible results (default = 888L). Only applies
to algorithms that use random initialization like Louvain.}
}
\value{
A list with three elements:
\itemize{
\item \code{aggregate}: A data frame with group statistics including group name,
number of papers, and average publication year
\item \code{network}: The input network with added group attributes
\item \code{pubs_by_year}: Publication counts by group and year
}
}
\description{
This function identifies and analyzes groups (communities) within scientific networks
created from articles and patents data. It can apply different clustering algorithms
to detect technological trajectories and emerging scientific fields.
}
\details{
The function first validates the input network, then applies the specified
clustering algorithm to detect communities within the network. It calculates
statistics for each detected group and returns the results along with the
augmented network. The function can handle multiple network components
simultaneously, applying clustering only to specified components.
}
\examples{
\dontrun{
# Assuming 'comps' is output from sniff_components()
groups <- sniff_groups(comps,
  min_group_size = 15,
  algorithm = "leiden",
  seed = 888L
)

# Access group statistics
groups$aggregate
groups$network
groups$pubs_by_year
}

}
\seealso{
\code{\link{sniff_components}()} for creating the input network components
}
