% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rle.R
\name{rlepack}
\alias{rlepack}
\alias{rlepack.integer}
\alias{rleunpack}
\alias{rleunpack.rlepack}
\alias{rev.rlepack}
\alias{unique.rlepack}
\alias{anyDuplicated.rlepack}
\title{Hybrid Index, rle-pack utilities}
\usage{
rlepack(x, ...)

\method{rlepack}{integer}(x, pack = TRUE, ...)

rleunpack(x)

\method{rleunpack}{rlepack}(x)

\method{rev}{rlepack}(x)

\method{unique}{rlepack}(x, incomparables = FALSE, ...)

\method{anyDuplicated}{rlepack}(x, incomparables = FALSE, ...)
}
\arguments{
\item{x}{in 'rlepack' an integer vector, in the other functions an object of
class 'rlepack'}

\item{...}{just to keep R CMD CHECK quiet (not used)}

\item{pack}{FALSE to suppress packing}

\item{incomparables}{just to keep R CMD CHECK quiet (not used)}
}
\value{
A list with components:
\itemize{
\item first: the first element of the packed sequence
\item dat: either an object of class \code{\link[=rle]{rle()}} or the complete input vector \code{x} if
rle-packing is not efficient
\item last: the last element of the packed sequence
}
}
\description{
Basic utilities for rle packing and unpacking and apropriate methods for
\code{\link[=rev]{rev()}} and \code{\link[=unique]{unique()}}.
}
\examples{

  x <- rlepack(rep(0L, 10))

}
\seealso{
\code{\link[ff:hi]{ff::hi()}}, \code{\link[=intrle]{intrle()}}, \code{\link[=rle]{rle()}}, \code{\link[=rev]{rev()}}, \code{\link[=unique]{unique()}}
}
\author{
Jens Oehlschlägel
}
\keyword{IO}
\keyword{data}
