% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_call.R
\name{bm_call}
\alias{bm_call}
\title{Execute a function call on bitmap objects}
\usage{
bm_call(x, .f, ...)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{"magick-image"}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{"raster"}  object.}

\item{.f}{A function to execute.}

\item{...}{Additional arguments to \code{.f}.}
}
\value{
The return value of \code{.f}.
}
\description{
\code{bm_call()} excutes a function call on bitmap objects.
Since its first argument is the bitmap object it is more
convenient to use with pipes then directly using \code{\link[base:do.call]{base::do.call()}}
plus it is easier to specify additional arguments.
}
\examples{
  font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
  font <- read_hex(font_file)
  bml <- as_bm_list("RSTATS", font = font)
  bml <- bm_flip(bml, "both")
  bm <- bm_call(bml, cbind, direction = "RTL")
  print(bm)
}
