% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_extend.R
\name{bm_extend}
\alias{bm_extend}
\alias{bm_extend.bm_bitmap}
\alias{bm_extend.bm_pixmap}
\alias{bm_extend.bm_list}
\alias{bm_extend.magick-image}
\alias{bm_extend.nativeRaster}
\alias{bm_extend.raster}
\title{Extend bitmaps on the sides with extra pixels}
\usage{
bm_extend(
  x,
  value,
  sides = NULL,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)

\method{bm_extend}{bm_bitmap}(
  x,
  value = 0L,
  sides = NULL,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)

\method{bm_extend}{bm_pixmap}(
  x,
  value = col2hex("transparent"),
  sides = NULL,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)

\method{bm_extend}{bm_list}(x, ...)

\method{bm_extend}{`magick-image`}(
  x,
  value = "transparent",
  sides = NULL,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)

\method{bm_extend}{nativeRaster}(
  x,
  value = col2int("transparent"),
  sides = NULL,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)

\method{bm_extend}{raster}(
  x,
  value = "transparent",
  sides = NULL,
  top = NULL,
  right = NULL,
  bottom = NULL,
  left = NULL,
  width = NULL,
  height = NULL,
  hjust = "center-left",
  vjust = "center-top"
)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{"magick-image"}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{"raster"}  object.}

\item{value}{Value for the new pixels.}

\item{sides}{If not \code{NULL} then an integer vector indicating how
many pixels to pad on all four sides.
If the integer vector is of length one it indicates the number of pixels for all four sides.
If of length two gives first the number for the vertical sides and then the horizontal sides.
If of length three gives the number of pixels for top, the horizontal sides, and then bottom sides.
If of length four gives the number of pixels for top, right, bottom, and then left sides.
This is the same scheme as used by the CSS padding and margin properties.}

\item{top}{How many pixels to pad the top.}

\item{right}{How many pixels to pad the right.}

\item{bottom}{How many pixels to pad the bottom.}

\item{left}{How many pixels to pad the left.}

\item{width}{How many pixels wide should the new bitmap be.
Use with the \code{hjust} argument or just one of either the \code{left} or \code{right} arguments.}

\item{height}{How many pixels tall should the new bitmap be.
Use with the \code{vjust} argument or just one of either the \code{top} or \code{bottom} arguments.}

\item{hjust}{One of "left", "center-left", "center-right", "right".
"center-left" and "center-right" will attempt to
place in "center" if possible but if not possible will bias
it one pixel left or right respectively.
"centre", "center", and "centre-left" are aliases for "center-left".
"centre-right" is an alias for "center-right".}

\item{vjust}{One of "bottom", "center-bottom", "center-top", "top".
"center-bottom" and "center-top" will attempt to
place in "center" if possible but if not possible will bias
it one pixel down or up respectively.
"centre", "center", and "centre-top" are aliases for "center-top".
"centre-bottom" is an alias for "center-bottom".}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
Depending on \code{x} either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{magick-image}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{raster}  object.
}
\description{
\code{bm_extend()} extends \code{\link[=bm_bitmap]{bm_bitmap()}} objects with extra pixels.
The directions and the integer value of the extra pixels are settable
(defaulting to \code{0L}).
}
\examples{
font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
font <- read_hex(font_file)
# add a border to an "R"
capital_r <- font[[str2ucp("R")]]
capital_r <- bm_extend(capital_r, value = 2L, sides = 1L)
capital_r <- bm_extend(capital_r, value = 3L, sides = 1L)
print(capital_r)

crops <- farming_crops_16x16()
corn <- crops$corn$portrait
corn_framed <- bm_extend(corn, value = "brown", sides = 1L)
if (cli::is_utf8_output() && cli::num_ansi_colors() >= 256L) {
  print(corn_framed, compress = "v")
}
}
\seealso{
\code{\link[=bm_expand]{bm_expand()}}, \code{\link[=bm_pad]{bm_pad()}}, \code{\link[=bm_resize]{bm_resize()}}, and \code{\link[=bm_trim]{bm_trim()}}.
}
