% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_invert.R
\name{bm_invert}
\alias{bm_invert}
\alias{bm_invert.bm_bitmap}
\alias{bm_invert.bm_list}
\alias{bm_invert.bm_pixmap}
\alias{bm_invert.magick-image}
\alias{bm_invert.nativeRaster}
\alias{bm_invert.raster}
\title{Invert (negate) a bitmap}
\usage{
bm_invert(x)

\method{bm_invert}{bm_bitmap}(x)

\method{bm_invert}{bm_list}(x)

\method{bm_invert}{bm_pixmap}(x)

\method{bm_invert}{`magick-image`}(x)

\method{bm_invert}{nativeRaster}(x)

\method{bm_invert}{raster}(x)
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{"magick-image"}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{"raster"}  object.}
}
\value{
Depending on \code{x} either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{magick-image}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{raster}  object.
}
\description{
\code{bm_invert()} inverts (negates) a bitmap.
}
\examples{
font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
font <- read_hex(font_file)
capital_r <- as_bm_bitmap("R", font = font)
capital_r_inverted <- bm_invert(capital_r)
print(capital_r_inverted)

corn <- farming_crops_16x16()$corn$portrait
corn_inverted <- bm_invert(corn)
if (cli::is_utf8_output() && cli::num_ansi_colors() >= 256L) {
  print(corn_inverted, compress = "v", bg = "black")
}
}
