% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bm_replace.R
\name{bm_replace}
\alias{bm_replace}
\alias{bm_replace.bm_bitmap}
\alias{bm_replace.bm_list}
\alias{bm_replace.bm_pixmap}
\alias{bm_replace.magick-image}
\alias{bm_replace.nativeRaster}
\alias{bm_replace.raster}
\title{Replace a color in a bitmap with another color}
\usage{
bm_replace(x, value, old)

\method{bm_replace}{bm_bitmap}(x, value = 0L, old = x[1L, 1L])

\method{bm_replace}{bm_list}(x, ...)

\method{bm_replace}{bm_pixmap}(x, value = col2hex("transparent"), old = x[1L, 1L])

\method{bm_replace}{`magick-image`}(x, value = "transparent", old = as.raster(x)[1L, 1L])

\method{bm_replace}{nativeRaster}(x, value = col2int("transparent"), old = x[1L, 1L])

\method{bm_replace}{raster}(x, value = "transparent", old = x[1L, 1L])
}
\arguments{
\item{x}{Either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{"magick-image"}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{"raster"}  object.}

\item{value}{New bitmap \dQuote{color} value.}

\item{old}{Old bitmap \dQuote{color} value to replace.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
Depending on \code{x} either a \code{\link[=bm_bitmap]{bm_bitmap()}}, \code{\link[=bm_font]{bm_font()}}, \code{\link[=bm_list]{bm_list()}}, \link[magick:editing]{magick-image}, "nativeRaster", \code{\link[=bm_pixmap]{bm_pixmap()}}, or \link[grDevices:as.raster]{raster}  object.
}
\description{
\code{bm_replace()} replaces a bitmap color with another color.
In particular default arguments will try to replace the background color.
}
\examples{
corn <- farming_crops_16x16()$corn$portrait
if (cli::is_utf8_output() && cli::num_ansi_colors() >= 256L) {
  print(bm_replace(corn, "cyan"), compress = "v")
}
font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
font <- read_hex(font_file)
capital_r <- font[[str2ucp("R")]]
print(bm_replace(capital_r, 2L))
}
