% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfer-entropy.R
\name{.get_pval}
\alias{.get_pval}
\title{Extract p-value from RTransferEntropy result}
\usage{
.get_pval(obj)
}
\arguments{
\item{obj}{An object for which \code{coef(obj)} returns a matrix
containing a p-value column.}
}
\value{
A numeric scalar with the extracted p-value, or
\code{NA_real_} if no suitable column is found or extraction fails.
}
\description{
Helper to extract a p-value from a coefficient table returned by
RTransferEntropy or similar packages. It searches for a column whose
name matches \code{"^p[._ -]?value$"} (case-insensitive) and returns
the first-row entry of that column.
}
\keyword{internal}
