% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continue_funs.R
\name{kmbayes_continue}
\alias{kmbayes_continue}
\title{Continue sampling from existing bkmr fit}
\usage{
kmbayes_continue(fit, ...)
}
\arguments{
\item{fit}{output from \code{\link[bkmr]{kmbayes}}}

\item{...}{arguments to \code{\link[bkmrhat]{kmbayes_continue}}}
}
\value{
a \code{bkmrfit.continued} object, which inherits from \code{bkmrfit} objects similar to \code{\link[bkmr]{kmbayes}} output, and which can be used to make inference using functions from the \code{bkmr} package.
}
\description{
Use this when you've used MCMC sampling with the \code{\link[bkmr]{kmbayes}} function, but you did not take enough samples and do not want to start over.
}
\details{
Note this does not fully start from the prior values of the MCMC chains. The \code{\link[bkmr]{kmbayes}} function does not allow full specification of the kernel function parameters, so this will restart the chain at the last values of all fixed effect parameters, and start the kernel \code{r} parmeters at the arithmetic mean of all \code{r} parameters from the last step in the previous chain.
}
\examples{
set.seed(111)
dat <- bkmr::SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X
\dontrun{
fitty1 = bkmr::kmbayes(y=y,Z=Z,X=X, est.h=TRUE, iter=100)
# do some diagnostics here to see if 100 iterations (default) is enough
# add 100 additional iterations (for illustration - still will not be enough)
fitty2 = kmbayes_continue(fitty1, iter=100)
cobj = as.mcmc(fitty2)
varnames(cobj)

}

}
\seealso{
\code{\link[bkmrhat]{kmbayes_parallel}}
}
