% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cta_button.R
\name{add_cta_button}
\alias{add_cta_button}
\title{Create an HTML fragment for a CTA button}
\usage{
add_cta_button(url, text, align = "center")
}
\arguments{
\item{url}{A URL for the button.}

\item{text}{The text that is placed atop the CTA button.}

\item{align}{The alignment of the button inside the main content area.
Options are \code{"center"} (the default), \code{"left"}, and \code{"right"}.}
}
\value{
A character object with an HTML fragment that can be placed inside
the message body wherever the CTA button should appear.
}
\description{
Create the HTML fragment for a call to action button. This can be used as
part of the email body but, since this HTML, it must be contained within
\code{\link[=md]{md()}}. There are options to specify the button text, the URL, and the
button's alignment.
}
\examples{
# Create the button as an HTML fragment
cta_button <-
  add_cta_button(
    url = "http://www.website.net",
    text = "Press This Button"
  )

# Include the button in the email
# message body by using it as part of
# a vector inside of `md()`
email <-
  compose_email(
    body = md(
      c(
  "Pressing the button will take
  you to an example website",
  cta_button
      )
    )
  )

if (interactive()) email

}
