% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_expr.R
\name{new_mutate_expr_block}
\alias{new_mutate_expr_block}
\alias{new_mutate_block}
\title{Mutate expression block constructor}
\usage{
new_mutate_expr_block(exprs = list(new_col = "1"), by = character(), ...)
}
\arguments{
\item{exprs}{Reactive expression returning character vector of
expressions}

\item{by}{Character vector of column names for grouping. Default is empty.}

\item{...}{Additional arguments forwarded to \code{\link[blockr.core:new_block]{blockr.core::new_block()}}}
}
\value{
A block object for mutate operations
}
\description{
This block allows to add new variables and preserve existing ones using R expressions
(see \code{\link[dplyr:mutate]{dplyr::mutate()}}). Changes are applied after clicking the submit button.
}
\examples{
# Create a mutate expression block
new_mutate_expr_block(exprs = list(mpg_squared = "mpg^2"))

if (interactive()) {
  # Basic usage with mtcars datase
  library(blockr.core)
  serve(new_mutate_expr_block(), data = list(data = mtcars))

  # With a custom dataset
  df <- data.frame(x = 1:5, check.names = FALSE)
  df$`2025 Sales` <- letters[1:5]
  serve(new_mutate_expr_block(), data = list(data = df))
}
}
\seealso{
\code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}
}
