% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{new_select_block}
\alias{new_select_block}
\title{Select block constructor}
\usage{
new_select_block(columns = character(), exclude = FALSE, distinct = FALSE, ...)
}
\arguments{
\item{columns}{Selected columns (character vector). If empty, selects all columns.}

\item{exclude}{Logical. If TRUE, uses exclude mode (dplyr minus syntax: \code{-c(col1, col2)}).
If FALSE (default), uses include mode (selects specified columns).}

\item{distinct}{Logical. If TRUE, keeps only distinct/unique rows after selecting columns.
If FALSE (default), returns all rows. This replaces the old \code{new_distinct_block()} functionality.}

\item{...}{Forwarded to \code{\link[blockr.core:new_transform_block]{blockr.core::new_transform_block()}}}
}
\value{
A transform block object of class \code{select_block}.
}
\description{
This block allows performing column subsetting on \code{data.frame} objects (see
\code{\link[dplyr:select]{dplyr::select()}}). Columns can be selected and reordered by dragging, and
an exclude mode allows for negative selection using dplyr's minus syntax.
Optionally, distinct rows can be kept after selection.
}
\details{
\strong{Note}: This block replaces the deprecated \code{new_distinct_block()}. Use the
\code{distinct} parameter to get unique rows after column selection.

The select block provides a sortable multi-select interface where columns can be:
\itemize{
\item Selected/deselected by clicking
\item Reordered by dragging (order is preserved in output)
\item Removed individually using the × button
}

\strong{Include mode (exclude = FALSE, default):}
\itemize{
\item Selected columns are included in output
\item Empty selection = select all (\code{select(data, dplyr::everything())})
}

\strong{Exclude mode (exclude = TRUE):}
\itemize{
\item Selected columns are excluded from output using minus syntax
\item Empty selection = select all (\code{select(data)})
\item Efficient for large datasets when you want to remove just a few columns
}

\strong{Distinct mode (distinct = TRUE):}
\itemize{
\item Keeps only distinct rows after column selection
\item Equivalent to piping \code{select()} output to \code{distinct()}
\item Useful for finding unique combinations of selected columns
}
}
\examples{
# Create a select block
new_select_block(columns = c("mpg", "cyl", "hp"))

if (interactive()) {
  # Basic usage with mtcars dataset
  library(blockr.core)
  serve(new_select_block(), list(data = mtcars))

  # With initial column selection
  serve(new_select_block(columns = c("mpg", "cyl", "hp")), list(data = mtcars))

  # Exclude mode (select all except specified columns)
  serve(new_select_block(columns = c("gear", "carb"), exclude = TRUE), list(data = mtcars))

  # Select with distinct (unique combinations)
  serve(new_select_block(columns = c("cyl", "gear"), distinct = TRUE), list(data = mtcars))

  # Full deduplication (distinct on all columns)
  serve(new_select_block(distinct = TRUE), list(data = mtcars))

  # Connected blocks example
  serve(
    new_board(
      blocks = list(
        a = new_dataset_block(),
        b = new_select_block()
      ),
      links = links(
        from = c("a"),
        to = c("b")
      )
    )
  )
}
}
