% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/css.R
\name{css-utilities}
\alias{css-utilities}
\title{CSS Utilities for blockr.io Blocks}
\description{
This file provides centralized CSS functions for consistent block styling.
All custom classes use the \verb{.block-} prefix to distinguish them from
framework classes (Bootstrap, Shiny, etc.) and prevent naming conflicts.
}
\details{
\strong{Required for all blocks:}
\itemize{
\item \code{css_responsive_grid()} - Base grid layout and block styling (REQUIRED)
}

\strong{Common optional utilities:}
\itemize{
\item \code{css_single_column()} - Force single-column layout (common)
\item \code{css_advanced_toggle()} - Collapsible sections with toggle (optional)
\item \code{css_inline_checkbox()} - Checkbox/label styling for inline layouts (optional)
}

\strong{Usage in block UI:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ui = function(id) \{
  tagList(
    css_responsive_grid(),        # Always include first
    css_single_column("myblock"), # If single column layout needed
    css_inline_checkbox(),        # If using inline checkboxes
    # ... block-specific CSS with tags$style(HTML(...)) ...
    # ... block HTML structure ...
  )
\}
}\if{html}{\out{</div>}}

Block-specific styling (unique to one block) should use \code{tags$style(HTML(...))}
directly in the block file, not added here. Only add CSS here if it's
reused by 2+ blocks.
}
\keyword{internal}
