% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_df.R
\name{sim_column}
\alias{sim_column}
\title{Get the collection of spatial interaction models from a SIM data frame}
\usage{
sim_column(sim_df)
}
\arguments{
\item{sim_df}{a data frame of spatial interaction models, an object of class
\code{sim_df}}
}
\value{
the collection of spatial interaction models in the \code{sim_df} object,
as a \code{sim_list} object
}
\description{
Get the collection of spatial interaction models from a SIM data frame
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(distances, production, seq(1.05, 1.45, by = 0.2),
  seq(1, 3, by = 0.5) / 400,
  attractiveness,
  bipartite = FALSE,
  epsilon = 0.1, iter_max = 1000,
)
all_flows_df <- sim_df(all_flows, sim_colum = "my_col")
names(all_flows_df)
sim_column(all_flows_df)
}
