% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bet.R
\name{bet}
\alias{bet}
\title{Posterior based Bayesian multigroup equivalence testing}
\usage{
bet(values, groups, em, A, B = 10000, test = "mean")
}
\arguments{
\item{values}{A vector of measurements sorted in the same order as the \code{groups} variable.}

\item{groups}{A vector of groups labels corresponding to the individual measurements in the \code{groups} variable.}

\item{em}{A c x 2 matrix of lower and upper equivalence margins. Here, c is the number of pairwise comparisons of interest.}

\item{A}{A c x k matrix of pairwise contrasts. Here, k is the number of groups, i.e., \code{length(unique(groups))}.}

\item{B}{A positive integer specifying the number of posterior samples to draw. By default \code{B} is set to 10000.}

\item{test}{Setting this to anything other than "mean" tells the function to not calculate the posterior probability that the average
differences fall within the equivalence margins (applicable when testing equivalence based on something other than just
average differences).}
}
\value{
The function returns a list object containing the following:
\itemize{
\item prob: The posterior probability that the average differences fall within the equivalence margins. Only returned if \code{test == "mean"}.
\item delta: A B x c matrix of posterior samples of the average difference for each pairwise comparison of interest.
\item sigma2: A B x k matrix of posterior samples of the variance for each group.
}
}
\description{
Function provides the necessary tools to carry out Bayesian multigroup equivalence testing based on sampling of the posterior distribution.
The function returns posterior samples of the average differences amongst groups, as well as posterior samples of group variances.
}
\examples{
### Multigroup equivalence test for A vs. B and A vs. C
values <- rnorm(75)
groups <- rep(LETTERS[1:3], each = 25)

mad1 <- 0.65  # The equivalence margin for A vs. B
mad2 <- 0.65  # The equivalence margin for A vs. C
mads <- c(mad1, mad2)
mads <- cbind(-mads, mads)

A <- apc(3)
A <- A[1:2, ]

out <- bet(values, groups, mads, A, B = 10000)

out$prob   # The posterior probability that the average
           # differences fall within the equivalence margins

}
\references{
Pourmohamad, T. and Lee, H.K.H. (2023). Equivalence Testing for Multiple Groups. Stat, e645.
}
