% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twinframework.R
\docType{data}
\name{twinframework}
\alias{twinframework}
\title{twinframework Bayesian Network}
\format{
A discrete Bayesian network to identify critical factors during the in-service phase and achieve sustainable operation and maintenance for building infrastructures. Probabilities were given within the referenced paper. The vertices are:
\describe{
\item{Weather}{(Fine weather, Bad weather);}
\item{SocialActivities}{(Active, No activity);}
\item{Time}{(Non-working hours, Working hours);}
\item{CampusActivities}{(Campus activities, No campus activities);}
\item{PersonnelType}{(Student, Social personnel);}
\item{EquipmentStatus}{(Good equipment, Equipment abnormality)}
\item{UsingPlayground}{(Use, Not in use);}
}
}
\value{
An object of class \code{bn.fit}. Refer to the documentation of \code{bnlearn} for details.
}
\description{
Sustainable operation and maintenance modeling and application of building infrastructures combined with digital twin framework.
}
\references{
Jiao, Z., Du, X., Liu, Z., Liu, L., Sun, Z., & Shi, G. (2023). Sustainable Operation and Maintenance Modeling and Application of Building Infrastructures Combined with Digital Twin Framework. Sensors, 23(9), 4182.
}
