% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.to.structure.R
\name{model.to.structure}
\alias{model.to.structure}
\title{Model to Bayesian Network Structure}
\usage{
model.to.structure(model)
}
\arguments{
\item{model}{Model string}
}
\description{
Creates a Bayesian Network structure based on a high level semantic model.
}
\examples{

library(bnlearn)
library(bnviewer)


model.left.arrow.op1 = "  A <- (B,C,D);
                          B <- (E,F);
                          F <- (G);
                       "

model.left.arrow.op2 = "  A <= (B,C,D);
                          B <= (E,F);
                          F <= (G);
                       "


model.right.arrow.op1 = " A -> (B,C,D);
                          B -> (E,F);
                          F -> (G);
                        "

model.right.arrow.op2 = " A => (B,C,D);
                          B => (E,F);
                          F => (G);
                        "

structure = model.to.structure(model.left.arrow.op1)

viewer(structure,
       bayesianNetwork.width = "100\%",
       bayesianNetwork.height = "80vh",
       bayesianNetwork.layout = "layout_on_grid",
       node.colors = list(background = "#f4bafd",
                         border = "#2b7ce9",
                         highlight = list(background = "#97c2fc",
                                          border = "#2b7ce9"))
      )

data.set = bnlearn::gaussian.test

bayesianNetwork.fit = bn.fit(structure, data = data.set)

print(bayesianNetwork.fit$A)

}
\references{
See online documentation \url{http://robsonfernandes.net/bnviewer}
}
