% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/version-management.R
\name{boilerplate_list_files}
\alias{boilerplate_list_files}
\title{List Available boilerplate Database Files}
\usage{
boilerplate_list_files(data_path = NULL, pattern = NULL, category = NULL)
}
\arguments{
\item{data_path}{Character. Path to the directory containing database files.
If NULL (default), uses tools::R_user_dir("boilerplate", "data").}

\item{pattern}{Character. Optional regex pattern to filter files.}

\item{category}{Character. Optional category to filter results.
Options include "measures", "methods", "results", "discussion",
"appendix", "template", or "unified".}
}
\value{
A list with class "boilerplate_files" containing:
\item{standard}{Data frame of standard database files}
\item{timestamped}{Data frame of timestamped versions}
\item{backups}{Data frame of backup files}
\item{other}{Data frame of other files that match the pattern}

Each data frame contains columns: file, path, size, modified, format,
base_name, timestamp, type, and category.
}
\description{
Lists all boilerplate database files in a directory, organised by type
(standard, timestamped, or backup).
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Initialise with some content
boilerplate_init(data_path = temp_dir, categories = "methods",
                 create_dirs = TRUE, confirm = FALSE, quiet = TRUE)

# Save with timestamp to create some files
db <- boilerplate_import(data_path = temp_dir, quiet = TRUE)
boilerplate_save(db, data_path = temp_dir, timestamp = TRUE,
                 confirm = FALSE, quiet = TRUE)

# List all database files
files <- boilerplate_list_files(data_path = temp_dir)
print(files)

# List only methods files
files <- boilerplate_list_files(data_path = temp_dir, category = "methods")

# List files matching a pattern
files <- boilerplate_list_files(data_path = temp_dir, pattern = "202")

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
\seealso{
\code{\link{boilerplate_import}} for importing the listed files,
\code{\link{boilerplate_restore_backup}} for restoring from backups.
}
