% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-functions.R
\name{boilerplate_measures}
\alias{boilerplate_measures}
\title{Access Measures from Unified Database}
\usage{
boilerplate_measures(unified_db, name = NULL)
}
\arguments{
\item{unified_db}{List. The unified boilerplate database}

\item{name}{Character. Optional specific measure to retrieve}
}
\value{
List. The requested measures database or specific measure
}
\description{
This function extracts and returns the measures portion of a unified database,
optionally retrieving a specific measure by name.
}
\examples{
# Create a temporary directory and initialise database
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_measures_example", "data")

# Initialise with default measures
boilerplate_init(
  categories = "measures",
  data_path = data_path,
  create_dirs = TRUE,
  create_empty = FALSE,
  confirm = FALSE,
  quiet = TRUE
)

# Import all databases
unified_db <- boilerplate_import(data_path = data_path, quiet = TRUE)

# Get all measures
measures_db <- boilerplate_measures(unified_db)
names(measures_db)

# Get a specific measure
if ("anxiety" \%in\% names(measures_db)) {
  anxiety_measure <- boilerplate_measures(unified_db, "anxiety")
  anxiety_measure$description
}

# Clean up
unlink(file.path(temp_dir, "boilerplate_measures_example"), recursive = TRUE)

}
