% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boilerplate_batch_edit_functions.R
\name{boilerplate_batch_clean}
\alias{boilerplate_batch_clean}
\title{Batch Clean Fields in boilerplate Database}
\usage{
boilerplate_batch_clean(
  db,
  field,
  remove_chars = NULL,
  replace_pairs = NULL,
  trim_whitespace = TRUE,
  collapse_spaces = FALSE,
  target_entries = NULL,
  exclude_entries = NULL,
  category = NULL,
  recursive = TRUE,
  preview = FALSE,
  confirm = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{db}{List. The database to clean (can be a single category or unified database).}

\item{field}{Character. The field to clean (e.g., "reference", "description").}

\item{remove_chars}{Character vector. Characters to remove from text fields.}

\item{replace_pairs}{List. Named list for replacements (e.g., list(" " = "_")).}

\item{trim_whitespace}{Logical. Whether to trim leading/trailing whitespace.}

\item{collapse_spaces}{Logical. Whether to collapse multiple spaces to single space.}

\item{target_entries}{Character vector. Entries to clean. Can be:
\itemize{
\item Specific entry names (e.g., c("ban_hate_speech", "born_nz"))
\item Patterns with wildcards (e.g., "anxiety*")
\item "all" to clean all entries
\item NULL to clean all entries with the specified field
}}

\item{exclude_entries}{Character vector. Entries to exclude from cleaning.
Can use specific names or wildcard patterns like target_entries}

\item{category}{Character. If db is unified, specifies which category to clean.}

\item{recursive}{Logical. Whether to search recursively through nested structures.}

\item{preview}{Logical. If TRUE, shows what would be changed without making changes.}

\item{confirm}{Logical. If TRUE, asks for confirmation before making changes.}

\item{quiet}{Logical. If TRUE, suppresses non-essential messages.}
}
\value{
The modified database.
}
\description{
This function allows batch cleaning of text fields by removing or replacing
specific characters or patterns across multiple entries in a boilerplate database.
}
\examples{
\donttest{
# First create a sample database
unified_db <- list(
  measures = list(
    test1 = list(reference = "@Smith2023[p.45]"),
    test2 = list(reference = "Jones[2022]")
  )
)

# Remove @, [, and ] from all references
unified_db <- boilerplate_batch_clean(
  db = unified_db,
  field = "reference",
  remove_chars = c("@", "[", "]"),
  category = "measures"
)

# Clean all entries EXCEPT specific ones
unified_db <- boilerplate_batch_clean(
  db = unified_db,
  field = "reference",
  remove_chars = c("@", "[", "]"),
  exclude_entries = c("forgiveness", "special_measure"),
  category = "measures"
)

# Clean specific entries only
unified_db <- boilerplate_batch_clean(
  db = unified_db,
  field = "reference",
  remove_chars = c("@", "[", "]"),
  target_entries = c("ban_hate_speech", "born_nz"),
  category = "measures"
)

# Clean all entries starting with "emp_" except "emp_special"
unified_db <- boilerplate_batch_clean(
  db = unified_db,
  field = "reference",
  remove_chars = c("@", "[", "]"),
  target_entries = "emp_*",
  exclude_entries = "emp_special",
  category = "measures"
)

# Replace characters and clean
unified_db <- boilerplate_batch_clean(
  db = unified_db,
  field = "reference",
  remove_chars = c("@", "[", "]"),
  replace_pairs = list(" " = "_", "." = ""),
  trim_whitespace = TRUE,
  category = "measures"
)

# Preview changes first
boilerplate_batch_clean(
  db = unified_db,
  field = "reference",
  remove_chars = c("@", "[", "]"),
  exclude_entries = "forgiveness",
  category = "measures",
  preview = TRUE
)
}

}
