% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project-functions.R
\name{boilerplate_list_projects}
\alias{boilerplate_list_projects}
\title{List Available Projects}
\usage{
boilerplate_list_projects(data_path = NULL, details = FALSE)
}
\arguments{
\item{data_path}{Character. Base path for boilerplate data. If NULL, uses default location.}

\item{details}{Logical. If TRUE, shows additional information about each project.}
}
\value{
Character vector of project names.
}
\description{
Lists all available boilerplate projects in the specified data path.
}
\examples{
\donttest{
# Create temporary directory for example
temp_dir <- tempfile()
dir.create(temp_dir)

# Initialise some projects
boilerplate_init(data_path = temp_dir, project = "project1",
                 create_dirs = TRUE, confirm = FALSE, quiet = TRUE)
boilerplate_init(data_path = temp_dir, project = "project2",
                 create_dirs = TRUE, confirm = FALSE, quiet = TRUE)

# List all projects
projects <- boilerplate_list_projects(data_path = temp_dir)
print(projects)

# List with details
boilerplate_list_projects(data_path = temp_dir, details = TRUE)

# Clean up
unlink(temp_dir, recursive = TRUE)
}

}
