% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_themes.R
\name{get_themes}
\alias{get_themes}
\title{Get Available Themes}
\usage{
get_themes(geography)
}
\arguments{
\item{geography}{geography as character string}
}
\value{
a \code{data.frame} with columns \code{ID} (theme identifier), \code{Bereich} (theme name)
and \code{Unterbereich} (sub-theme name).
}
\description{
\code{get_themes} retrieves a data frame with all available themes
}
\details{
To get a list of available geographies use \code{\link{get_geographies}}.
}
\examples{

# The SSL vertification seems to fail for some Linux systems. 
# This is likely because of a SSL certificate issue on the INKAR server. 
# Disabling SSL verification comes with risks: 
# https://curl.se/libcurl/c/CURLOPT_SSL_VERIFYPEER.html
httr::set_config(httr::config(ssl_verifypeer = 0L))

# Available themes  
get_themes("KRE")

# Reset configuration  
httr::reset_config()



}
\seealso{
\code{\link{get_geographies}}
}
