% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppw.R
\name{lam}
\alias{lam}
\title{Lag window}
\usage{
lam(s)
}
\arguments{
\item{s}{a time series.}
}
\value{
A lag window for spectral estimation.
}
\description{
The function \code{lam} is used to construct a "flat-top" lag window
for spectral estimation based on Politis, D.N. and J.P. Romano (1995),
"Bias-Corrected Nonparametric Spectral Estimation", Journal of Time Series
Analysis, vol. 16, No. 1.
}
\details{
This function constructs a lag window used in spectral estimation.
More details about the lag window and its usage can be found in the referenced papers.
}
\examples{
# Generate a sequence for testing
s <- seq(-1, 1, by = 0.1)
# Calculate the lag window using the lam function
lag_window <- lam(s)
# Plot the generated lag window
plot(lag_window, type="l")
}
\references{
Patton, A., Politis, D.N. and  White, H. (2009).
Correction to ``Automatic Block-Length Selection for the Dependent Bootstrap''
by D. Politis and H. White, \emph{Econometric Reviews}, \bold{ 28}, 372-375.
}
\seealso{
\code{\link{blockboot}}, \code{\link{b.star}}
}
\author{
Original code in Matlab by A. Patton, R translation and modifications
by C. Parmeter and J. Racine. We are grateful to Andrew Patton and Dimitris
Politis for their assistance and feedback. Kindly report features,
deficiencies, and improvements to \email{racinej@mcmaster.ca}.
}
\keyword{"Optimal}
\keyword{"Stationary}
\keyword{block}
\keyword{length"}
\keyword{series"}
\keyword{time}
