% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPseudoBlocks.R
\name{GetPseudoBlocks}
\alias{GetPseudoBlocks}
\title{Computing Pseudo-regenerative Blocks}
\usage{
GetPseudoBlocks(
  x,
  s,
  eps_opt,
  delta_opt,
  p_XiXip1,
  m = min(x),
  M = max(x),
  func = sum,
  ...
)
}
\arguments{
\item{x}{A numeric vector representing a Markov chain.}

\item{s}{A real number specifying the center of the small set.}

\item{eps_opt}{A numeric value for the size of the small set.}

\item{delta_opt}{A numeric value for the lower bound in the minorization condition.}

\item{p_XiXip1}{A numeric value representing the estimator of the transition density.}

\item{m}{A numeric value; the lower truncation threshold
Default is the 5th percentile of \code{x}.}

\item{M}{A numeric value; the upper truncation threshold
Default is the 95th percentile of \code{x}.}

\item{func}{A function to apply to each block. Default is \code{sum}.}

\item{...}{Additional arguments passed to the function \code{func}.}
}
\value{
Returns a list containing:
\enumerate{
\item A data frame with the following columns:
\itemize{
\item \code{Time} - the index of each observation,
\item \code{x} - values of the process,
\item \code{Bnumber} - block number assigned to each observation,
\item \code{regen} - indicator (1 or 0) of regeneration times. 1 corresponds to
the regeneration time.
}
\item A matrix summarizing block characteristics with the following columns:
\itemize{
\item \code{Block number} - the block index,
\item \code{Block length} - number of observations in the block,
\item \code{Truncated sum} - the value of \code{func} applied to truncated
observations in the block,
\item \code{Valid points} - number of observations within the truncation thresholds,
\item \code{Winsorized value} - the Winsorized value of \code{func} applied to the block,
\item \code{Start index} - the starting index of the block,
\item \code{End index} -  the ending index of the block.
}
\item \code{Total blocks} - the total number of regeneration blocks.
}
}
\description{
The function computes pseudo-regenerative
blocks for general Markov chains.
}
\details{
The function begins by determining which elements of \code{x} are
within an interval \eqn{[s-esp_opt,s+eps_opt]}. Then an estimated Nummelin
splitting trick is performed using the estimators \eqn{p_n(X_i,X_{i+1})}.
}
\examples{
\donttest{
n=200# the length of the process
# Generating the AR(1) process
coeff=0.75
X = arima.sim(n=n, list(ar = c(coeff)))
# Find the small ensemble with the largest number of regeneration
sm <- findBestEpsilon(X,s=0,plotIt=FALSE)
f =sm$trans
eps = sm$epsilon
delta = sm$delta
m = sm$s
Pseudo_blocks=GetPseudoBlocks(X, m, eps_opt = eps, delta_opt = delta, p_XiXip1 = f,func=sum)
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P. and Clémençon, S. (2006). Regenerative block bootstrap for Markov
chains. \emph{Bernoulli}, \bold{12}, 689-712.
}
\seealso{
\code{\link{findBestEpsilon}}, \code{\link{ftrunc}},
\code{\link{regenboot}}, \code{\link{smallEnsemble}}.
}
\keyword{"Markov}
\keyword{"Nummelin}
\keyword{"Regenerative}
\keyword{"Small}
\keyword{Block}
\keyword{Bootstrap"}
\keyword{chains"}
\keyword{set"}
\keyword{splitting}
\keyword{trick"}
